/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit.prism;

import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.webkit.prism.PrismImage;
import com.sun.prism.Graphics;
import com.sun.prism.Image;
import com.sun.prism.PrinterGraphics;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.prism.image.CompoundCoords;
import com.sun.prism.image.CompoundImage;
import com.sun.prism.image.CompoundTexture;
import com.sun.prism.image.Coords;
import com.sun.prism.image.ViewPort;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import javafx.scene.image.PixelFormat;

final class WCImageImpl
extends PrismImage {
    private static final PlatformLogger log = PlatformLogger.getLogger((String)WCImageImpl.class.getName());
    private final Image img;
    private Texture texture;
    private CompoundTexture compoundTexture;

    WCImageImpl(int n2, int n3) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("Creating empty image({0},{1})", new Object[]{n2, n3});
        }
        this.img = Image.fromIntArgbPreData((int[])new int[n2 * n3], (int)n2, (int)n3);
    }

    WCImageImpl(int[] nArray, int n2, int n3) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("Creating image({0},{1}) from buffer", new Object[]{n2, n3});
        }
        this.img = Image.fromIntArgbPreData((int[])nArray, (int)n2, (int)n3);
    }

    WCImageImpl(ImageFrame imageFrame) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("Creating image {0}x{1} of type {2} from buffer", new Object[]{imageFrame.getWidth(), imageFrame.getHeight(), imageFrame.getImageType()});
        }
        this.img = Image.convertImageFrame((ImageFrame)imageFrame);
    }

    @Override
    Image getImage() {
        return this.img;
    }

    @Override
    Graphics getGraphics() {
        return null;
    }

    @Override
    void draw(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        ResourceFactory resourceFactory;
        if (graphics instanceof PrinterGraphics) {
            Texture texture = graphics.getResourceFactory().createTexture(this.img, Texture.Usage.STATIC, Texture.WrapMode.CLAMP_NOT_NEEDED);
            graphics.drawTexture(texture, (float)n2, (float)n3, (float)n4, (float)n5, (float)n6, (float)n7, (float)n8, (float)n9);
            texture.dispose();
            return;
        }
        if (this.texture != null) {
            this.texture.lock();
            if (this.texture.isSurfaceLost()) {
                this.texture = null;
            }
        }
        if (this.texture == null && this.compoundTexture == null) {
            resourceFactory = graphics.getResourceFactory();
            int n10 = resourceFactory.getMaximumTextureSize();
            if (this.img.getWidth() <= n10 && this.img.getHeight() <= n10) {
                this.texture = resourceFactory.createTexture(this.img, Texture.Usage.DEFAULT, Texture.WrapMode.CLAMP_TO_EDGE);
                assert (this.texture != null);
            } else {
                this.compoundTexture = new CompoundTexture(this.img, n10);
            }
        }
        if (this.texture != null) {
            assert (this.compoundTexture == null);
            graphics.drawTexture(this.texture, (float)n2, (float)n3, (float)n4, (float)n5, (float)n6, (float)n7, (float)n8, (float)n9);
            this.texture.unlock();
        } else {
            assert (this.compoundTexture != null);
            resourceFactory = new ViewPort((float)n6, (float)n7, (float)(n8 - n6), (float)(n9 - n7));
            Coords coords = new Coords((float)(n4 - n2), (float)(n5 - n3), (ViewPort)resourceFactory);
            CompoundCoords compoundCoords = new CompoundCoords((CompoundImage)this.compoundTexture, coords);
            compoundCoords.draw(graphics, (CompoundImage)this.compoundTexture, (float)n2, (float)n3);
        }
    }

    @Override
    void dispose() {
        if (this.texture != null) {
            this.texture.dispose();
            this.texture = null;
        }
        if (this.compoundTexture != null) {
            this.compoundTexture.dispose();
            this.compoundTexture = null;
        }
    }

    @Override
    public int getWidth() {
        return this.img.getWidth();
    }

    @Override
    public int getHeight() {
        return this.img.getHeight();
    }

    @Override
    public ByteBuffer getPixelBuffer() {
        int n2 = this.img.getWidth();
        int n3 = this.img.getHeight();
        int n4 = n2 * 4;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n4 * n3);
        this.img.getPixels(0, 0, n2, n3, PixelFormat.getByteBgraInstance(), (Buffer)byteBuffer, n4);
        return byteBuffer;
    }

    @Override
    public float getPixelScale() {
        return this.img.getPixelScale();
    }
}

